import {
	get,
	post
} from '../utils/request.js'


export default {
	// 用户注册
	reg(data) {
		return post('/api/user/register', data)
	},
	// 用户登录
	login(data) {
		return post('/api/user/login', data)
	},
	// 用户登出
	logout(data) {
		return post('/api/user/logout')
	},
	// 获取微信绑定二维码
	getWechatImg() {
		return post('/api/user/getuserwechat')
	},
	// 获取用户是否绑定微信
	getuserwechat(data) {
		return post('/api/user/userbindwechat', data, {
			loading: false
		})
	},
	//修改密码
	changepwd(data) {
		return post('/api/user/changepwd', data)
	},
	//用户认证
	userauth(data) {
		return post('/api/user/userauth', data)
	},
	//获取客服信息
	getkefu(){
		return post('/api/user/getkefu')
	},

	// 获取用户信息
	getProfile(data) {
		return post('/api/user/UserInfo',data)
	},
	
	// 解绑微信
	unbindWechat(data) {
		return post('/api/user/unbindWechat',data)
	},

	// 更新用户信息
	updateProfile(data) {
		return put('/user/profile', data)
	}
}