import Vue from 'vue'
import VueRouter from 'vue-router'
import store from '../store' // 直接导入Store
import Login from '../views/login/Login.vue'
import Reg from '../views/login/Reg.vue'
import Home from '../views/home/Home.vue'
import PatentAll from '../views/home/patentlist.vue'
import Mine from '../views/home/Mine.vue'
import My from '../views/user/My.vue'
Vue.use(VueRouter) // 注册路由插件

// 定义路由规则
const routes = [{
		path: '/',
		name: 'Home',
		component: Home,
		meta: {
			requiresAuth: true
		}
	},
	{
		path: '/login',
		name: 'Login',
		component: Login,
		meta: {
			guestOnly: true
		}
	},
	{
		path: '/Reg',
		name: 'Reg',
		component: Reg,
		meta: {
			guestOnly: true
		}
	},
	{
		path: '/PatentAll',
		name: 'PatentAll',
		component: PatentAll,
		meta: {
			requiresAuth: true
		}
	},
	{
		path: '/Mine',
		name: 'Mine',
		component: Mine,
		meta: {
			requiresAuth: true
		}
	},
	{
		path: '/My',
		name: 'My',
		component: My,
		meta: {
			requiresAuth: true
		}
	}
]

// 创建路由实例
const router = new VueRouter({
	mode: 'hash',
	// mode: 'history', // 可选：使用 HTML5 History 模式（需后端支持）
	base: process.env.BASE_URL,
	routes
})

router.beforeEach((to, from, next) => {
	// const isAuthenticated = router.app.$store.getters.isAuthenticated
	const isAuthenticated = store.getters.isAuthenticated
	const requiresAuth = to.matched.some(record => record.meta.requiresAuth)
	const guestOnly = to.matched.some(record => record.meta.guestOnly)
	if (requiresAuth && !isAuthenticated) {
		next({
			name: 'Login',
			query: {
				redirect: to.fullPath
			}
		})
	} else if (guestOnly && isAuthenticated) {
		next({
			name: 'Home'
		})
	} else {
		next()
	}
})

export default router