// store/index.js
import Vue from 'vue';
import Vuex from 'vuex';

Vue.use(Vuex);

export default new Vuex.Store({
	state: {
		userinfo: localStorage.getItem('userinfo') || null,
		token: localStorage.getItem('token') || null
	},
	mutations: {
		SET_TOKEN(state, token) {
			state.token = token
			localStorage.setItem('token', token)
		},
		CLEAR_TOKEN(state) {
			state.token = null
			localStorage.removeItem('token')
		}
	},
	actions: {
		login({
			commit
		}, credentials) {
			return new Promise((resolve, reject) => {
				// 这里替换实际登录API调用
				if (credentials.username === 'admin' && credentials.password === '123456') {
					commit('SET_TOKEN', 'demo-token')
					resolve()
				} else {
					reject(new Error('认证失败'))
				}
			})
		},
		logout({
			commit
		}) {
			commit('CLEAR_TOKEN')
		}
	},
	getters: {
		isAuthenticated: state => !!state.token
	}
})